#!/bin/bash

set -e
PWD="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
echo "Get CCMB Versions" 
installedVersion=`$PWD/check-installed-version.sh`
candidateVersion=`$PWD/check-candidate-version.sh`

echo "installedVersion: '$installedVersion'" ${#installedVersion}
echo "candidateVersion: '$candidateVersion'" ${#candidateVersion}

if [ "$installedVersion" = "$candidateVersion" ] ; then
	echo "No update required, installed version is the same as candidate"
	exit 0
fi
systemctl stop network-manager
systemctl disable systemd-tmpfiles-clean.timer
sleep 2 
echo "Uploading files to CCMB board:"

$PWD/upload-update.sh

echo "Updating CCMB from $installedVersion to $candidateVersion"

ssh -o ServerAliveInterval=4 -o ServerAliveCountMax=10 -o ConnectTimeout=2 -o TCPKeepAlive=yes root@192.168.9.2 /unzipUpgrade.sh > /dev/null 2>&1 &

set +e
#wait for unzipUpgrade to kill CCMB
sleep 5

startTime="$(date -u +%s)"

printf 'Please wait...'
#Wait until CCMB will be available again.
#Installation procedure will restart CCMB unit 4 times and at the end it will turn on the CCMB which will open port 9000
for var in {1..1800}
do
	nc -z -w 1 192.168.9.2 9000 > /dev/null 2>&1
	ccmbStatus=$?

	currentTime="$(date -u +%s)"
	elapsed="$(($currentTime-$startTime))"

	# echo "elapsed $elapsed"

	if [ $ccmbStatus -eq 0 ] ; then
		installedVersion=`$PWD/check-installed-version.sh 2>&1`
                rootfsVersion=`$PWD/check-rootfs-version.sh 2>&1`

                if [ "$installedVersion" = "$candidateVersion" -a "$rootfsVersion" = "$candidateVersion" ] ; then
			echo ""
			echo "CCMB has been successfully updated"
                        # make sure /tmp is cleaned now after CCMB update has finished
                        systemctl start systemd-tmpfiles-clean.service
                        systemctl start network-manager
			exit 0
		else
			echo ""
			echo "CCMB version ($installedVersion) different than expected ($candidateVersion)"
                        # make sure /tmp is cleaned now after CCMB update has finished
                        systemctl start systemd-tmpfiles-clean.service
                        systemctl start network-manager
			exit 1
		fi
	fi

        if [ $elapsed -eq 1800 ] ; then
                echo ""
                echo "Failed to update CCMB. Socket is not available after 30 minutes."
                # make sure /tmp is cleaned now after CCMB update has finished
                systemctl start systemd-tmpfiles-clean.service
                systemctl start network-manager
		exit 1
	fi

	sleep 1
	printf '.'
done

echo ""
echo "Failed to update CCMB. Socket is not available after 30 minutes."
# make sure /tmp is cleaned now after CCMB update has finished
systemctl start systemd-tmpfiles-clean.service
systemctl start network-manager
exit 1
